<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="fn"
    xmlns:pl="http://product-live.com"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    version="3.0"
    exclude-result-prefixes="xs fn pl">
    
    <!-- The output method must be json. If you use the Product-Live extension remember to set the output extension of the file to json to -->
    <xsl:output method="json" indent="yes" encoding="UTF-8" />
    
    <xsl:template match="/">
        <!-- A JSON is a map, so your whole JSON file must be encapsulated in a xsl:map -->
        <xsl:map>
            <!--
                Each properties of a JSON file are set with map-entry, a map-entry has a key, which is the property name, add a value in the select.
                In the JSON format the value is typed, which means for example that string and number are not represented the same way.
                Below you will find some differences. The first one is to force the content to be a string with the string() function.
                Don't worry to escape special characters, xsl:map-entry will do it for you.
            -->
            <xsl:map-entry key="'tableKey'" select="/Table/@key/string()" />
            <!-- When the value is an array, the best practice is to first build the array and then set the property with the function array{}, see below in the documents with array{$items} -->
            <xsl:map-entry key="'items'">
                <!-- When you create the array variable, you must set as item()* -->
                <xsl:variable name="items" as="item()*">
                    <xsl:for-each select="Table/Items/Item">
                        <xsl:map>
                            <xsl:for-each select="Identifier">
                                <!-- Notice that the key is @key not {@key} -->
                                <xsl:map-entry key="@key" select="string()" />
                            </xsl:for-each>
                            <xsl:for-each select="Classification">
                                <xsl:map-entry key="@key" select="string()" />
                            </xsl:for-each>
                            <xsl:for-each select="Conditional-Formatting">
                                <xsl:map-entry key="@key" select="string()" />
                            </xsl:for-each>
                            <xsl:for-each-group select="Field" group-by="@key">
                                <xsl:choose>
                                    <!-- Data type: MULTIPLE-SELECT MULTIPLE-SELECT-QUANTIFIED MULTIPLE-SELECT-QUANTIFIED-WITH-COMMENTS -->
                                    <xsl:when test="count(current-group()) &gt; 1">
                                        <xsl:map-entry key="current-grouping-key()" select="array{current-group()/string()}" />
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:choose>
                                            <!-- Data type: NUMBER -->
                                            <xsl:when test="number() and not(contains(., 'E'))">
                                                <xsl:map-entry key="current-grouping-key()" select="number()" />
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <xsl:map-entry key="current-grouping-key()" select="string()" />
                                            </xsl:otherwise>
                                        </xsl:choose>   
                                    </xsl:otherwise>
                                </xsl:choose>              
                            </xsl:for-each-group>
                        </xsl:map>
                    </xsl:for-each>   
                </xsl:variable>
                <!-- Copy as array -->
                <xsl:copy-of select="array{$items}"/>  
            </xsl:map-entry>
        </xsl:map>
    </xsl:template>
</xsl:stylesheet>